/** @param {jQuery} $ jQuery Object */
!function($, window, document, _undefined)
{
	fetchSimilarThreads = function(title)
	{
		XenForo.ajax($('[name=similarthreadsurl]').data('similarthreadsurl'), {query: title}, function(ajaxData, textStatus)
		{
			if (XenForo.hasResponseError(ajaxData) || !ajaxData)
			{
				return false;
			}

			if (ajaxData.templateHtml === '')
			{
				$("#SimilarThreads").xfFadeUp(XenForo.speed.fast, function() { $(this).empty()});
			}
			else
			{
				new XenForo.ExtLoader(ajaxData, function()
				{
					if ($("#SimilarThreads").is(":empty"))
					{
						$("#SimilarThreads").html(ajaxData.templateHtml).css('display', 'none').xfFadeDown(XenForo.speed.fast).xfActivate();
					}
					else
					{
						$("#SimilarThreads").html(ajaxData.templateHtml).xfActivate();
					}
				});
			}
		});
	}

	SimilarThreads = function($input)
	{
		$input.keypress(function(e)
		{
			if (e.charCode == 32)
			{
				fetchSimilarThreads($(this).val());
			}
		});
		
		$input.blur(function(e)
		{
			fetchSimilarThreads($(this).val());
		});
	}
	
	DismissSimilarThreads = function($trigger)
	{
		$trigger.click(function(e)
		{
			$("#ctrl_title_thread_create").unbind();
			$("#SimilarThreads").xfFadeUp(XenForo.speed.fast, function() { $(this).empty()});
		});
	}
	
	XenForo.register('#ctrl_title_thread_create', 'SimilarThreads');
	XenForo.register('#DismissSimilarThreads', 'DismissSimilarThreads')

}
(jQuery, this, document);